/*****************************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          C O R O U T I N E                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung des Koroutinenkonzepts.                                   */
/* Die Klasse erweitert die Klasse Runnable um die Moeglichkeit die Kontrolle*/
/* an andere Coroutinen abzugeben.                                           */
/*****************************************************************************/

#include "thread/context.h"
#include "thread/coroutine.h"
#include "thread/kickoff.h"

// Funktionen, die auf der Assembler-Ebene implementiert werden, muessen als
// extern "C" deklariert werden, da sie nicht dem Name-Mangeling von C++ 
// entsprechen.

Coroutine::Coroutine(void* tos) {
  this->stack_base = tos;
}

void Coroutine::resume(Coroutine* next) {
  switch_context(&tos,next->tos);
}

void Coroutine::go() {
  load_context(tos);
}

void Coroutine::init() {
  tos = stack_base;
  init_context(&tos,kickoff,this);
}
