/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                 T O C                                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die Struktur toc dient dazu, bei einem Koroutinenwechsel die Werte der    */
/* nicht-fluechtigen Register zu sichern.                                    */
/* Beim GNU C Compiler sind eax, ecx und edx fluechtige Register, die bei    */
/* Funktionsaufrufen und somit auch bei einem Koroutinenwechsel keine        */
/* spaeter noch benoetigten Werte haben duerfen. Daher muss in der Struktur  */
/* toc auch kein Platz fuer sie bereitgestellt werden.                       */
/*****************************************************************************/

// TOC_SETTLE: bereitet den Kontext der Koroutine fuer den ersten
//             Aufruf vor.

#include "thread/runnable.h"

extern "C" void init_context(void** sp,
			     void   (*kickoff)(Runnable*),
			     void*  object)
{
  register void **sp_temp = (void**)*sp;

  /* Compare the stack layout assumed here to the one describe in context.s
   * the pointer to object is stored on the stack it will be retrieved from
   * the stack within the kickoff function and placed in register r0
   */

  *(--sp_temp) = object;         // object pointer
  *(--sp_temp) = (void*)0x1f;    // cpsr - threads are executed in system mode
  *(--sp_temp) = (void*)kickoff; // link register
  sp_temp -= 9;                  // register 4-12

  *sp = (void*)sp_temp;
}
