/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*           S C H E D U L E R _ I M P L E M E N T A T I O N                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Interface to the implementation of the scheduler, in this case of a       */
/* round-robin scheduler.                                                    */
/*****************************************************************************/

#ifndef __scheduler_implementation_h__
#define __scheduler_implementation_h__

#include "infra/types.h"

#include "devices/scheduler_implementation_timer.h"

#include "interrupt/guard.h"

#include "object/chain.h"
#include "object/queue.h"

#include "thread/dispatch.h"
#include "thread/scheduler_base.h"
#include "thread/thread.h"

class Scheduler_Implementation : public Scheduler_Implementation_Timer, public Scheduler_Base, public Queue, public Dispatcher {

  friend       class Guard;

protected:

  Thread*      schedule();

public:

  void         start();
  void         reschedule();

  void         add(Thread*);
  void         remove(Thread*);

  void         yield();
  void         exit();
  void         kill(Thread*);
  
  void         block(Thread*,Queue*);
  void         wakeup(Thread*);

  us_type      set_timeslice(us_type);
  us_type      get_timeslice();

  bool         isr();
  void         dsr();

  Thread*      dequeue() {
    return static_cast< Thread* >(Queue::dequeue());
  }

  Thread*      peek() {
    return static_cast< Thread* >(Queue::peek());
  }
};

#endif /* __scheduler_implementation_h__ */
