/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                   C P U                                   */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung einer Abstraktion fuer den Prozessor.                     */
/* Derzeit wird nur angeboten, Interrupts zuzulassen, zu verbieten oder den  */
/* Prozessor anzuhalten.                                                     */
/*****************************************************************************/

#ifndef __cpu_h__
#define __cpu_h__

#include "devices/cpu_implementation.h"

/**
 * \class CPU
 * \brief Abstraction of the processor.
 */
class CPU : public CPU_Implementation {

public:

  /**
   * \brief Allow interrupts.
   */
  void enable_int() { CPU_Implementation::enable_int(); }

  /**
   * \brief Forbid interrupts.
   */
  void disable_int() { CPU_Implementation::disable_int(); }

  /**
   * \brief Stop the CPU.
   */
  void halt() { CPU_Implementation::halt(); }

  /**
   * \brief Set the cpu to sleep mode.
   */
  void sleep() { CPU_Implementation::sleep(); }

  /**
   * \brief Set the stack pointer of the CPU
   * \param new_sp The new value of the stack pointer.
   * \attention This method must be inlined!
   */
  void set_sp(void* new_sp) { CPU_Implementation::set_sp(new_sp); }
};

#endif
