/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*             D E R I V A T E _ I M P L E M E N T A T I O N                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Eine Abstraktion fuer ein 'konkretes' Derivat                             */
/*---------------------------------------------------------------------------*/

#ifndef __derivate_implementation_h__
#define __derivate_implementation_h__

#include "devices/cpu.h"
#include "devices/interrupt_controller.h"
#include "infra/memory_mapped.h"
#include "infra/types.h"

/**
 * \class Derivate_Implementation
 * \brief Abstraction of one concrete derivate of a  processor architecture
 **/
class Derivate_Implementation : public CPU {

  /**
   * \brief Wait State Control Register
   **/
  Memory_Mapped< ezstubs_uint16,0x04000204 >  WAITCNT;

  /**
   * \brief Power Down Register
   **/
  Memory_Mapped< ezstubs_uint16,0x04000300 >  HALTCNT;

public:

  /**
   * \brief Duration of one module clock tick in nanoseconds
   * \return Duration of one module clock tick in nanoseconds
   **/ 
  ns_type module_tick();

  /**
   * \brief Frequency of the module clock in MHz
   * \return Frequency of the module clock in MHz
   **/
  ezstubs_uint16 module_freq_MHz();

  /**
   * \brief Frequency of the module clock in Hz
   * \return Frequency of the module clock in Hz
   **/
  ezstubs_uint32 module_freq_Hz();

  void enable_int() {
    ic.enable_int();
    CPU::enable_int();
  }

  void disable_int() {
    ic.disable_int();
    CPU::disable_int();
  }
};

#endif /* __derivate_implementation_h__ */
