/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                            D S R _ S t o r e                              */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Diese Klasse bewahrt die aktivierten DSRs auf, die nicht abgearbeitet     */
/* werden konnten, weil sie innerhalb eines geschuetzen Abschnitts aktiviert */
/* wurden.                                                                   */
/*****************************************************************************/

#ifndef __interrupt_dsr_store_h__
#define __interrupt_dsr_store_h__

#include "interrupt/gate.h"
#include "object/queue.h"

/**
 * \brief Managing relayed dsrs
 **/
class DSR_Store {

protected:
  /**
   * \brief List of pending dsrs
   */
  Queue dsr_queue;

  /**
   * \brief Get a dsr from the list of pending dsrs. 
   *
   * Get an dsr from the list of pending dsrs. Interrupts are locked
   * during this operation to ensure the consistency of the dsr-queue.
   */
  Gate* remove_dsr();

  /**
   * \brief Are there any dsrs pending?
   * \retval true There are pending dsrs.
   * \retval false There are no pending dsrs.
   */
  bool  dsrs_pending();

public:

  /**
   * \brief Execute a dsr.
   *
   * The dsr is executed immediately or queued if we have interrupted
   * a secured section.
   */
  void relay(Gate *item);
};

#endif /* __interrupt_dsr_store_h__ */
