#!/usr/bin/perl -w

#====================================
#Script for submissions via "make"
#Deletes old submission and copies 
#the new one into tags/aufgabeX, 
#using svn cp and svn rm.
#====================================
use Cwd;

my $exercise; #Exercise's name, e.g. aufgabe1

if(!$ARGV[0]){
    die("Usage: $0 <exercise>\n");
}else{
    $exercise = $ARGV[0];
    if(!($exercise =~ /aufgabe\d/)){
        die("Wrong exercise name. -> aufgabe[1-5].\n");
    }
}

# determine the SVN URL via svn info

my @svninfo = `svn info .`;
my $svnurl = '';
foreach my $line (@svninfo) {
    if($line =~ s/^URL:\s*//) {
	$svnurl = $line;
	last;
    }
}
chomp($svnurl);

my $finished = 0;
do {
    my @svncontent = `svn ls $svnurl`;
    if(grep { /^Makefile$/ } @svncontent) {
	$finished = 1;
    }
    else {
	$svnurl =~ s/\/[\/]*$//;
    }
} until $finished;

my ($svnbaseurl) = $svnurl =~ /(.*\/gruppe\d+)/;

print "Submitting exercise $exercise in repository $svnurl\n";

if($svnurl =~ /tags\/$exercise^/) {
    print "Please either submit your exercise from the trunk or a branch, but do not renew it within a given tag\n";
}
else {
    print "Deleting old submission ($svnbaseurl/tags/$exercise)\n";
    `svn rm --force $svnbaseurl/tags/$exercise -m "deleting old submission"`;

    print "Copying new submission... \n";
    print "Source URL: $svnurl ... \n";
    print "Target URL: $svnbaseurl/tags/$exercise ... \n";
    `svn cp $svnurl $svnbaseurl/tags/$exercise -m "Submitting exercise $exercise"`;
}

print "Done.\n";
