%.size: %.elf
	@echo ELF-SIZE
	@$(SIZE) $<

%.arm9: %.elf
	@echo "OBJCOPY $@"
	@$(OBJCOPY) -O binary $< $@

%.nds: %.arm9
	@echo "NDSTOOL $@"
	@$(NDSTOOL) -c $@ -9 $< -e9 0x8000000

%.sim_exec: %.nds
	$(DESMUME)  $< 

%.sim_gdb: %.nds make/gdb.init 
	export GDBPORT=`cat ./make/gdb.port` ; \
	$(DESMUME) $(DESMUMEGDB) $(DESMUMEFLAGS) $*.nds & \
	DPID=$$! ; \
	sleep 1; \
	export searchdirs=`find $(SRC_DIR) -type d -not -regex '\..*test.*' -exec echo -n ' --directory {}' \;` ;\
	export searchdirs="--directory $(dir $@) $${searchdirs}"; \
	xterm -e  $(GDB) $(GDBFLAGS) $${searchdirs} $*.elf ; \
	kill -9 $$DPID ; \
	rm -f make/gdb.init ; \
	rm -f make/gdb.port

%.sim_ddd: %.nds make/gdb.init 
	export GDBPORT=`cat ./make/gdb.port` ; \
	$(DESMUME) $(DESMUMEGDB) $(DESMUMEFLAGS)  $*.nds & \
	DPID=$$! ; \
	sleep 1; \
	export searchdirs=`find $(SRC_DIR) -type d -not -regex '\..*test.*' -exec echo -n ' --directory {}' \;` ;\
	export searchdirs="--directory $(dir $@) $${searchdirs}"; \
	xterm -e ddd --debugger $(GDB) $(GDBFLAGS) $${searchdirs} $*.elf ; \
	kill -9 $$DPID ; \
	rm -f make/gdb.init ; \
	rm -f make/gdb.port

%.target_exec: %.bin
	@echo "TRANSMIT  $@"
	@echo
	@$(RCXFIRMDL) --fast --tty=$(RCXTTY) -s $<

%.target_debug: %.bin
	@echo "Not available!"

# these targets are to be used by the testrunner only

%.sim_run: %.elf %.nds 
	$(DESMUME) $(DESMUMEGDB) $(DESMUMEFLAGS)  $*.nds & \
	DPID=$$! ; \
	echo $$DPID ; \
	echo $$GDBPORT ; \
	sleep 1; \
	$(GDB) --command $*.gdb $< > $*.log ; \
	kill -9 $$DPID

%.target_run: %.elf
	echo "Not implemented"

# for the debugger

make/gdb.init:
	export GDBPORT=`./make/findport.pl` ;  \
	echo GDBPORT = $${GDBPORT} ; \
	echo $${GDBPORT} >> ./make/gdb.port ; \
	perl -e 'my $$temp = $(GDB_REMOTE_CMD); $$temp =~ s/<PORT>/$$ENV{GDBPORT}/; print "$$temp\n"' > $@
	echo load >> $@
