/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                         A B S T R A C T _ T H R E A D                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* ThreadQueue, more than mutiple threads per priority are allowed. The order*/
/* of activations could not be preserved.                                    */
/*****************************************************************************/

#ifndef __abstract_thread_queue_h__
#define __Abstract_thread_queue_h__

#include "infra/types.h"
#include "object/t_queue.h"
#include "thread/thread.h"

class Abstract_thread_queue{

 protected:
  /**
   * the queues for the different priorities
   **/
  T_Queue< Thread > *queues;

  /**
   * the maximum thread priority among all threads, that are ready for
   * execution.
   **/
  prio_type max_prio;

  prio_type max;

 public:

	/**
	 *	Constructor.
	**/
	Abstract_thread_queue(prio_type maxpr, T_Queue< Thread > *q, prio_type max_prio);


  /**
   * \brief Compute the maximum priority
   * \see max_prio
   **/
   void compute_max_prio();


  /**
   * \brief Get thread with highest priority.
   * \return The thread with the highest priority among all ready threads.
   *
   * The thread will not be removed from the ready queue.
   **/
   Thread *peek();


  /**
   * \brief Add an element at the beginning of a queue.
   * \param thread The element to be added.
   **/
   void    push_back(Thread *thread);


  /**
   * \brief Add a thread to the ready queue
   * \param thread The thread to be added to the ready quueue.
   *
   * A thread will be added at the end of the ready queue.
   **/
   void    enqueue(Thread *thread);


  /**
   * \brief Get thread with highest priority.
   * \return The thread with the highest priority among all ready threads.  
   *
   * Remove and return the thread with the highest priority among all ready
   * threads from the ready queue.
   **/
   Thread  *dequeue();


  /**
   * \brief Remove a thread from the ready queue.
   * \param thread The thread to be removed from the ready queue
   **/
   void    remove(Thread *thread);

};

#endif
