/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*     G U A R D E D _ S C H E D U L E R _ I M P L E M E N T A T I O N       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* A guarded interface for the multilevelqueue scheduler                     */
/*****************************************************************************/

#ifndef __guarded_multi_level_queue_scheduler_h__
#define __guarded_multi_level_queue_scheduler_h__

#include "interrupt/secure.h"

#include "thread/thread.h"
#include "thread/multi_level_queue_scheduler.h"

/**
 * \brief A Multi-Level-Queue-Scheduler guarded against interrupts
 **/
class Guarded_Multi_Level_Queue_Scheduler : protected Multi_Level_Queue_Scheduler {

public:

  Thread* current();

  void add(Thread* thread);

  void yield();

  void exit();

  void kill(Thread* thread);

};

#endif /* __guarded_multi_level_queue_scheduler_h__*/
