/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          I d l e  _ T h r e a d                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Idle Thread for the Multi-Level-Queue-Scheduler                           */
/*****************************************************************************/

#ifndef __thread_scheduler_multi_level_queue_scheduler_idle_thread_h__
#define __thread_scheduler_multi_level_queue_scheduler_idle_thread_h__

#include "thread/thread.h"

/**
 * \brief An idle thread implementation
 *
 * The multi level queue scheduler basically also works without an idle thread.
 * But there is one problem: we use the interrupt stack for the startup, ie.
 * when an interrupt occurs before we switch to a thread and so also the the
 * thread stack, we might destroy the stack we are running on, when we use
 * a seperate interrupt stack.
 **/
class Idle_Thread : public Thread {

public:

  /**
   * \brief Constructor
   **/
  Idle_Thread();

  /**
   * brief Idle thread action method
   **/
  void action();
};

/**
 * \brief Global idle thread instance
 **/
extern Idle_Thread idle_thread;

#endif /* __thread_scheduler_multi_level_queue_scheduler_idle_thread_h__ */
