/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               T H R E A D                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Kontrollflussabstraktion mit einem eigenen Stack und einer Prioritaet     */
/*****************************************************************************/

#ifndef __thread_h__
#define __thread_h__

#include "infra/types.h"
#include "object/chain.h"
#include "thread/coroutine.h"

class Multi_Level_Queue_Scheduler;

/**
 * \class Thread
 **/
class Thread : public Coroutine, public Chain {

  /**
   * \brief The threads current priority
   **/
  prio_type priority;


  /**
   * \brief The counter of thread activations
   **/
  ezstubs_uint8 activation_count;

protected:

  friend class Multi_Level_Queue_Scheduler;

public:

  /**
   * \brief Constructor
   * \param prio The threads priority. The priority is assigned statically, when
   *             the thread is created and immutable for the user afterwards
   * \param tos A pointer to the top of the stack, that should be used for the
   *            execution of this thread.
   **/
  Thread(prio_type prio,void* tos) 
    : Coroutine(tos),
      priority(prio),
      activation_count(0) {}

  /**
   * \brief Destructor
   **/
  virtual ~Thread() {}

  /**
   * \brief Get the thread's current priority.
   * \return The thread's current priority.
   **/    
  virtual prio_type get_priority() { return priority; }
};

#endif /* __thread_h__ */
