/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          T H R E A D _ Q U E U E                          */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* ThreadQueue, more than mutiple threads per priority are allowed. The order*/
/* of activations could not be preserved.                                    */
/*****************************************************************************/

#ifndef __thread_queue_multi_prio_multi_act_no_order_h__
#define __thread_queue_multi_prio_multi_act_no_order_h__

#include "infra/types.h"
#include "object/t_queue.h"
#include "thread/thread.h"
#include "abstract_thread_queue.h"




/**
 * \class Thread_Queue
 * \brief Managing the threads, that are ready for execution
 *
 * This Thread_Queue manages the threads ready for execution,it supports
 * - multiple threads per priority
 * - multiple priorities
 * - multiple activations of each thread
 * but it does not preserve the order of thread activations
 * 
 * This class is implemented as template as it is not possible to allocate
 * an array of an arbitrary size without dynamic memory management. The 
 * template parameter reflects the number of different priority levels.
 **/
template< prio_type MAX_PRIO > class Thread_Queue : public Abstract_thread_queue{

  /**
   * the queues for the different priorities
   **/
  T_Queue< Thread > q[MAX_PRIO];

public:

  /**
   * \brief Constructor
   **/
  Thread_Queue() : Abstract_thread_queue(MAX_PRIO, q, 0) {}

};



#endif /* __thread_queue_multi_prio_multi_act_no_order_h__ */
