/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                            K I C K O F F                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Funktion zum Starten einer Koroutine.                                     */
/* Da diese Funktion nicht wirklich aufgerufen, sondern nur durch eine       */
/* geschickte Initialisierung des Stacks der Koroutine angesprungen wird,    */
/* darf sie nie terminieren. Anderenfalls wuerde ein sinnloser Wert als      */
/* Ruecksprungadresse interpretiert werden und der Rechner abstuerzen.       */
/*****************************************************************************/

#include "thread/get_object.h"
#include "thread/runnable.h"
#include "interrupt/guard.h"

// void kickoff (Coroutine* object)  __attribute__ ((cdecl)) ;     
// leider wird das Attribute 'cdecl' ignoriert, 
// sonst braeuchte man nicht den unten stehenden Workaround...

void kickoff(Runnable* object) {

  GET_OBJECT();

  guard.leave();
  object->action();

  // object->action() kehrt hoffentlich nie hierher zurueck
  
  for (;;) {}
}

