/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                     S C H E D U L E _ T A B L E                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* This class represents the schedule that is executed by the Schedule-Table-*/
/* Scheduler.                                                                */
/*---------------------------------------------------------------------------*/

#ifndef __schedule_table_h__
#define __schedule_table_h__

#include "infra/types.h"
#include "infra/utils.h"
#include "thread/abstract_schedule_table.h"
#include "thread/thread.h"

/**
 * \class Schedule_Table
 * \brief A schedule table of a certain size.
 *
 * The reason why the Schedule_Table-class is implemented as a template is, that
 * in EZStubs there is no dynamic memory management available. So we have to 
 * allocate the storage for our schedule table statically. But how can we do this
 * without using templates?
 */
template< ezstubs_uint8 SIZE > class Schedule_Table : public Abstract_Schedule_Table {

  /**
   * \brief Initialize the schedule table.
   * \param real_timer_period For each schedule table there is one period that would
   *        fit best for the given schedule table. But in some cases the timer is
   *        capable of producing interrupts with the wished period. So we have to
   *        initialize the schedule table dependent on the period the timer offers us.
   */
  virtual void init(us_type real_timer_period);

  /**
   * \brief Get a schedule table entry
   * \param slot The index of entry of the schedule table to be fetched
   * \return The requested schedule table entry
   **/
  virtual Schedule_Table_Entry* get_entry(ezstubs_uint8 slot) {
    return 0;
  }

public:

  
  /**
   * \brief Constructor
   * \param tos A pointer to the top of the stack the schedule table runs on.
   * \param round The duration of a scheduler round, ie. the schedule table
   *              will be executed periodically every round microseconds
   **/
  Schedule_Table(void* tos,us_type round) : Abstract_Schedule_Table(tos,round) {
  }

  /**
   * \brief Returns to size of the schedule table
   * \return The size of the schedule table
   **/
  ezstubs_uint8 size() {
    return 0;
  }

  /**
   * \brief Add new tuple consisting of an offset and a pointer to a thread
   *        to the schedule table.
   * \param offset The offset (counted from the beginning of the schedule table
   *               when the  thread should be started. The offset may not exceed
   *               the scheduler round.
   * \param thread The thread that should be started
   * \attention The tuples have to be added in a proper order. Tuples added later
   *            also have to contain greater offsets.
   */  
  void add(us_type offset,Thread* thread);
};

template< ezstubs_uint8 SIZE > void Schedule_Table< SIZE >::init(us_type real_timer_period) {
}

template< ezstubs_uint8 SIZE > void Schedule_Table< SIZE >::add(us_type offset,Thread* thread) {
}

#endif /* __schedule_table_h__ */
