/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                    S C H E D U L E R _ T H R E A D                        */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die scheduler-spezifische Thread-Implementierung                          */
/*****************************************************************************/

#ifndef __thread_h__
#define __thread_h__

#include "thread/runnable.h"

/**
 * \class Scheduler_Thread
 * \brief Scheduler specific thread implementation.
 *
 * Nothing special about this class, the only difference to the
 * standard thread is, that it is directly derived from Runnable
 * not from Coroutine. The explanation is quite simple: The schedule
 * table scheduler starts a thread, this thread runs to its end,
 * then the next thread is started, therefore there's no need to
 * really dispatch between different threads, so we do not need a
 * Coroutine like concept.
 */
class Thread : public Runnable {
};

#endif /* __thread_h__ */
