/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*            S C H E D U L E _ T A B L E _ C O R O U T I N E                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* This class represents the schedule that is executed by the Schedule-Table-*/
/* Scheduler. It is implemented as coroutine so the scheduler can easily     */
/* switch between periodic and non-periodic activities                       */
/*---------------------------------------------------------------------------*/

#ifndef __abstract_schedule_table_coroutine__
#define __abstract_schedule_table_coroutine__

#include "infra/types.h"

#include "thread/abstract_schedule_table.h"
#include "thread/coroutine.h"

/**
 * \class Abstract_Schedule_Table_Coroutine
 * \brief A schedule table and a coroutine in one class
 * 
 * For supporting aperiodic threads we need real threads with an own stack for
 * them, as they can be preempted by a thread ran by the schedule table. To 
 * switch easily between aperiodic threads and the schedule table, the schedule
 * table is implemented as a coroutine
 **/
class Abstract_Schedule_Table_Coroutine 

  : public Abstract_Schedule_Table, public Coroutine

{
public:

  /**
   * \brief Constructor
   * \param tos A pointer to the top of the stack on which the threads of the
   *            schedule table shall be executed.
   * \param round How long does it take to execute the schedule table once
   */
  Abstract_Schedule_Table_Coroutine(void* tos,us_type round) 
    : Abstract_Schedule_Table(tos,round),Coroutine(tos) {}

  /**
   * within the action()-method of the schedule table the different threads
   * belonging to the schedule table are executed. This means we query the
   * next thread to be executed and call it's action()-method. If there is
   * no thread to be executed next, we just exit from this 
   * "Schedule_Table_Thread".
   **/
  virtual void action();
};

#endif /* __abstract_schedule_table_coroutine__ */
