/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*              G U A R D E D _ S C H E D U L E _ T A B L E _                */
/*              S C H E D U L E R _ A P  E R I O D I C                       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Schnittstelle der eigentlichen Schedulerimplementierung, die gegen        */
/* Unterbrechungen geschützt ist.                                            */
/*****************************************************************************/

#ifndef __guarded_schedule_table_scheduler_aperiodic_h__
#define __guarded_schedule_table_scheduler_aperiodic_h__

#include "interrupt/secure.h"
#include "thread/abstract_schedule_table_coroutine.h"
#include "thread/schedule_table_scheduler_aperiodic.h"
#include "thread/thread_aperiodic.h"

/**
 * \class Guarded_Schedule_Table_Scheduler_Aperiodic
 * \brief  A thread safe interface for the scheduler
 */
class Guarded_Schedule_Table_Scheduler_Aperiodic : protected Schedule_Table_Scheduler_Aperiodic {
public:

  void set_schedule_table(Abstract_Schedule_Table_Coroutine* schedule_table) {
  }

  Abstract_Schedule_Table_Coroutine* switch_schedule_table(Abstract_Schedule_Table_Coroutine* schedule_table) {
    return 0;
  }

  void ready(Thread_Aperiodic* thread) {
  }

  void exit() {
  }

  void start() {
  }
};

#endif /* __guarded_schedule_table_scheduler_aperiodic_h__ */
