/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*           S C H E D U L E R _ I M P L E M E N T A T I O N                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Interface to the implementation of the scheduler, in this case of a       */
/* scheduletable scheduler.                                                  */
/*****************************************************************************/

#ifndef __schedule_table_scheduler_aperiodic_h__
#define __schedule_table_scheduler_aperiodic_h__

#include "object/t_queue.h"
#include "thread/abstract_schedule_table_coroutine.h"
#include "thread/dispatch.h"
#include "thread/schedule_table_scheduler.h"
#include "thread/thread_aperiodic.h"

/**
 * \class Schedule_Table_Scheduler_Aperiodic
 * \brief Schedule table scheduler with support for aperiodic threads
 **/
class Schedule_Table_Scheduler_Aperiodic : public Schedule_Table_Scheduler, public Dispatcher, public T_Queue< Thread_Aperiodic > {

  /**
   * does the scheduler currently execute a periodic thread
   **/
  bool         running_periodic;

public:

  /**
   * Constructor
   **/
  Schedule_Table_Scheduler_Aperiodic() : running_periodic(false) {}

  /**
   * \brief Start the scheduler.
   * \attention May only be called once!
   * \attention May not be called before set_schedule_table()!
   * \see Scheduler_Implementation::set_schedule_table()
   *
   * Begin to execute the schedule set be set_schedule_table()
   */
  void start();

  /**
   * \brief Determinte the next thread to be executed and switch threads.
   * \see Guard::leave()
   * \see Scheduler_Implementation::get_need_reschedule()
   * This method is called by the system when leaving a secured section and
   * scheduling is necessary. Periodic threads are scheduled like the normal
   * schedule table scheduler schedules them, aperiodic threads are scheduled
   * within the gaps between the periodic threads in a fifo manner.
   */
  void reschedule();

  /**
   * \brief Add an aperiodic thread for execution
   * \param thread The aperiodic thread to be executed.
   * \attention Each aperiodic thread may only be activated once!
   **/
  void ready(Thread_Aperiodic* thread);

  /**
   * \brief Stop the execution of the currently running thread
   * \note This method is suitable for exiting periodic and aperiodic threads
   **/
  void exit();

  /**
   * The isr dealing with the timer interrupts.
   */  
  bool isr();

  /**
   * The dsr dealing with the timer interrupts.
   */
  void dsr();

  /**
   * \brief Set the schedule should be executed.
   * \param schedule_table A pointer to the schedule that should be executed.
   * \attention Must be called before start()!
   * \attention May only be called before start()!
   * \see Scheduler_Implementation::start()
   */
  void set_schedule_table(Abstract_Schedule_Table_Coroutine* schedule_table) {
  }

  /**
   * \brief Get the schedule that is currently executed.
   * \return The currently executed schedule.
   */
  Abstract_Schedule_Table_Coroutine* get_schedule_table() { 
    return 0;
  }

  /**
   * \brief Execute a different schedule.
   * \param schedule_table The schedule that should be executed next.
   * \return The currently executed schedule.
   * \attention May only be called after start()!
   * \attention The currently executed schedule may not be altered!
   *
   * The schedules are not exchanged immediately after switch_schedule_table() has been
   * called. The current schedule is executed until the current round is finished, then
   * the switch occurs and the new schedule will be executed.
   */
  Abstract_Schedule_Table_Coroutine* switch_schedule_table(Abstract_Schedule_Table_Coroutine* schedule_table) {
    return 0;
  }
};

#endif /* __schedule_table_scheduler_aperiodic_h__ */
