/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*            S C H E D U L E R _ T H R E A D _ A P E R I O D I C            */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die scheduler-spezifische Thread-Implementierung für nicht periodische    */
/* Threads ohne Deadline                                                     */
/*****************************************************************************/

#ifndef __thread_aperiodic_h__
#define __thread_aperiodic_h__

#include "object/chain.h"
#include "thread/coroutine.h"

/**
 * \class Thread_Aperiodic
 * \brief Scheduler specific thread implementation for non-periodic threads
 *        without timing restrictions. In contrast to the periodic threads
 *        aperiodic thread derive from the Coroutine class as they can be 
 *        preempted by periodic threads and continued later on, after the 
 *        periodic thread finished execution.
 **/
class Thread_Aperiodic : public Coroutine, public Chain {

public:

  /**
   * \brief Constructor
   * \param tos A pointer to the top of the aperiodic threads stack
   **/
  Thread_Aperiodic(void* tos) : Coroutine(tos) {}

  /**
   * \brief Has the aperiodic thread already been activated?
   * \retval true The aperiodic thread has already been activated.
   * \retval false The aperiodic thread has not been activated so far.
   **/
  bool ready() {}
};

#endif /* __thread_aperiodic_h__ */
