/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               T H R E A D                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Kontrollflussabstraktion mit einem eigenen Stack und einer Prioritaet     */
/*****************************************************************************/

#ifndef __thread_h__
#define __thread_h__

#include "infra/types.h"
#include "object/chain.h"
#include "thread/coroutine.h"

/**
 * \class Thread
 **/
class Thread : public Coroutine, public Chain {

public:

  /**
   * \brief Constructor
   * \param prio The threads priority. The priority is assigned statically, when
   *             the thread is created and immutable for the user afterwards
   * \param tos A pointer to the top of the stack, that should be used for the
   *            execution of this thread.
   **/
  Thread(prio_type prio,void* tos) : Coroutine(tos) {}

  /**
   * \brief Destructor
   **/
  virtual ~Thread() {}
};

#endif /* __thread_h__ */
