/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          T H R E A D _ Q U E U E                          */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* ThreadQueue, more than mutiple threads per priority are allowed. The order*/
/* of activations could not be preserved.                                    */
/*****************************************************************************/

#ifndef __thread_queue_multi_prio_multi_act_no_order_h__
#define __thread_queue_multi_prio_multi_act_no_order_h__

#include "infra/types.h"
#include "object/t_queue.h"
#include "thread/thread.h"

/**
 * \class Thread_Queue
 * \brief Managing the threads, that are ready for execution
 *
 * This Thread_Queue manages the threads ready for execution,it supports
 * - multiple threads per priority
 * - multiple priorities
 * - multiple activations of each thread
 * but it does not preserve the order of thread activations
 * 
 * This class is implemented as template as it is not possible to allocate
 * an array of an arbitrary size without dynamic memory management. The 
 * template parameter reflects the number of different priority levels.
 **/
template< prio_type MAX_PRIO > class Thread_Queue {

public:

  /**
   * \brief Constructor
   **/
  Thread_Queue() {}

  /**
   * \brief Get thread with highest priority.
   * \return The thread with the highest priority among all ready threads.
   *
   * The thread will not be removed from the ready queue.
   **/
  Thread* peek() {
    return 0;
  }

  /**
   * \brief Add a thread to the ready queue
   * \param thread The thread to be added to the ready quueue.
   *
   * A thread will be added at the end of the ready queue.
   **/
  void enqueue(Thread* thread) {}

  /**
   * \brief Get thread with highest priority.
   * \return The thread with the highest priority among all ready threads.  
   *
   * Remove and return the thread with the highest priority among all ready
   * threads from the ready queue.
   **/
  Thread* dequeue() {
    return 0;
  }

  /**
   * \brief Remove a thread from the ready queue.
   * \param thread The thread to be removed from the ready queue
   **/
  void remove(Thread* thread) {}
};

#endif /* __thread_queue_multi_prio_multi_act_no_order_h__ */
