/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                     D E F E R R A B L E _ S E R V E R                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* A deferrable Server                                                       */
/*****************************************************************************/

#ifndef __deferrable_server_h__
#define __deferrable_server_h__

#include "infra/types.h"
#include "thread/thread.h"

template < ezstubs_uint8 MAX_PRIO >
class Multi_Level_Queue_Scheduler_Deferrable_Server;

/**
 * \class Deferrable_Server
 * \brief A thread implementing a deferrable server
 **/
class Deferrable_Server : public Thread {

  friend class Multi_Level_Queue_Scheduler_Deferrable_Server<8>;

public:
  
  /**
   * \brief Constructor
   * \param prio The priority assigned to the deferrable server.
   * \param tos The stack assigned to the deferrable server.
   * \param budget The execution budget assigned to the deferrable server.
   * \param replenish The replenishment period assigned to the deferrable server.
   **/
  Deferrable_Server(prio_type prio,void* tos,us_type budget,us_type replenish) 
    : Thread(prio,tos)
  {}

  /**
   * \brief Replenish the execution budget.
   **/
  void replenish() {}

  /**
   * \brief Consume a certain amount of the execution budget
   * \param time The amount of the execution budget to consume
   **/
  void consume(us_type time) {}

  /**
   * \brief Consume all the execution budget that is left.
   **/
  void consume_all() {}

  /**
   * \brief Get the remaining execution budget of the deferrable server.
   * \return The remaining execution budget of the deferrable server.
   **/
  us_type get_current_budget() { return 0; }

  /**
   * \brief Get the replenishment period assigned to the deferrable server.
   * \return The replenishment period assigned to the deferrable server.
   **/
  us_type get_replenishment_period() { return 0; }
};

#endif /* __deferrable_server_h__ */
