/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*         D S R _ E x e c u t o r _ I n t e r r u p t _ S t a c k           */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Diese Klasse fuehrt die DSRs die vom DSR_Store aufbewahrt werden auf dem  */
/* Interrupt-Stack aus.                                                      */
/*****************************************************************************/

#ifndef __interrupt_dsr_executor_interrupt_stack_h__
#define __interrupt_dsr_executor_interrupt_stack_h__

#include "interrupt/dsr_executor_base.h"

/**
 * \brief Execute the dsrs on the interrupt stack
 *
 * Switching to the interrupt stack is not that easy - we cannot switch
 * the stack inside a method, the this pointer might be passed via the stack
 * and would not be accessible any more. So we use a plain C-function that
 * does not rely on the stack at all.
 * Inside this C-Function we switch to the interrupt stack, invoke the method
 * to execute the dsrs and switch back to the normal stack
 **/
void execute_dsrs();

/**
 * \brief Execute dsrs on the interrupt stack
 **/
class DSR_Executor_Interrupt_Stack : public DSR_Executor_Base {
public:

  /**
   * The helper method to execute the dsrs is not visible publicly, so we
   * have to make this C-function a friend
   **/
  friend void execute_dsrs();

  /**
   * \brief Execute the pending dsrs
   * \see execute_dsrs
   *
   * Execute the dsrs by calling execute_dsrs.
   **/
  void execute_pending_dsrs();
};

#endif /* __interrupt_dsr_executor_interrupt_stack_h__ */
