#include "interrupt/guard.h"
#include "thread/guarded_scheduler.h"

void Guard::leave() {
  /****************************************************************************
   * necessary so we can cope with nested interrupts                          *
   ****************************************************************************/
  if(lock == 1) {
    do {
      
      /**
       * check for pending interrupts and execute them
       */
      execute_pending_dsrs();
      
      /**
       * activate the scheduler if necessary
       */
      if(scheduler.get_need_reschedule()) {
	scheduler.reschedule();
      }

      /**
       * During the context switch, new dsrs could have been queued.
       * So we check here for them, if we would not the would stay pending
       * until the next secured section and it is not guaranteed that another
       * secured section will be entered.
       */
    } while(dsrs_pending());
  }
  
  retne();
}
