/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               L O C K E R                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die Klasse Locker implementiert eine Sperrvariable, die verwendet wird,   */
/* um kritische Abschnitte zu schuetzen. Die Variable zeigt allerdings nur   */
/* an, ob der kritische Abschnitt frei ist. Ein eventuelles Warten und der   */
/* Schutz der fuer diese Klasse notwendigen Zaehlfunktion muss ausserhalb    */
/* erfolgen.                                                                 */
/*****************************************************************************/

#ifndef __Locker_include__
#define __Locker_include__

/**
 * \class Locker
 * \brief A lock used to secure critical sections.
 */
class Locker {

protected:

  /**
   * \brief The lock variable
   */
  int lock;

public:

  /**
   * \brief Constructor
   *
   * Initially the Locker is not locked
   **/
  Locker() : lock(0) {};

  /**
   * \brief Enter a critical section.
   */
  void enter();
  
  /**
   * \brief Leave a critical section.
   */
  void retne();

  /**
   * \brief Is the critical section available? Can we enter it?
   */
  int avail() const;
};

#endif
