/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                 P A N I C                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Standard Unterbrechungsbehandlung.                                        */
/*****************************************************************************/

#ifndef __panic_include__
#define __panic_include__

/* INCLUDES */

#include "interrupt/gate.h"

/**
 * \class Panic
 * \brief The default interrupt handler.
 */
class Panic : public Gate {

private:

  int tmp;

public:

  /**
   * \brief Constructor
   **/
  Panic() : Gate() {}
    	      
  /**
   * Stops the processor.
   */
  bool isr();

  /**
   * Is never called for this interrupt handler, but it has to be there
   * to satisfy the linker.
   */
  void dsr();       

  /**
   * Is never called for this interrupt handler, but it has to be there
   * to satisfy the linker.
   */
  void acknowledge();
};

extern Panic panic;

#endif

