
	.macro init_stack

	# for some reason interrupts are enabled when we are here
	# so the first thing we do is disablem them, all of them !!
	# we do this when switching to the different modes to
	# initialize the stack
		
	# first switch to irq mode and initialize the interrupt sp

        mov     r0,#0xd2
        msr     cpsr,r0
        ldr     sp,=__isr_stack_end

	# then switch to the supervidsor mode and initialize the
	# sp for the dsrs

	mov	r0,#0xd3
        msr     cpsr,r0
        ldr     sp,=__dsr_stack_end
		
	# finally we switch to system mode for the rest of the startup
	# and the application running afterwards

	mov     r0, #0xdf
	msr     cpsr, r0

	# finally, for the normal startup we use the irq stack

	ldr	sp,=__isr_stack_end	
		
	.endm
		.macro save_context

	# first of all get the register back saved by the gba bios
		
	ldmfd   sp!,{r0-r3,r12,lr}

	# then, switch to supervisor mode and supervisor stack to 
	# save the  registers to the system mode stack
	# but first of all we stack some registers we need inside
	# the interrupt handler

	stmfd	sp!,{r4,r5,r6,r7}
	mrs	r4,cpsr
	mrs	r6,spsr
	mov	r5,r4
	mov	r7,lr
	orr	r4,r4,#0x1f
	msr	cpsr,r4

	# we have to save here:
	# - some scratch registers, that are also saved by the rom
	#   handler, but we need them on the thread stack
	#   regs: r0-r3,r12
	# - the spsr, so we can restore it when we return to the 
	#   interrupted program
	#   regs: r6
	# - the interrupt's link register, so we can return to the
	#   place where the 'normal' program has been interrupted
	#   regs: r7
	# - finally: the link register of the interrupted program,
	#   there is only one for all threads and when we get interrupted
	#   inside a subroutine call we still have to be able to return
	#   from this subroutine call
	#   regs: lr
	   
	
	stmfd	sp!,{r0-r3,r12}
	stmfd	sp!,{lr}
	stmfd	sp!,{r7}
	stmfd	sp!,{r6}

	# switch back to the interrupt mode and interrupt stack

	msr	cpsr,r5
	ldmfd	sp!,{r4,r5,r6,r7}

	.endm
	
	.macro switch_to_thread_stack
	
	# when calling guard leave it may happen that a context switch
	# occurs because scheduling is necessary. As we use the stack
	# to save the thread context, we have to switch to the stack of
	# the interrupted thread, so we can save its context there.
	# As we are no longer running in interrupt mode, we can now
	# enable interrupts again, as the link register will then be
	# saved by the processor's mode change

	mrs	r0,cpsr
	orr	r0,r0,#0x1f
	mov	r1,#0x80
	mvn	r1,r1
	and	r0,r0,r1
	msr	cpsr,r0

	.endm

	.macro return_from_wrapper

	# returning from the interrupt handler is a bit nasty
	# we have everything we need on the system stack and run
	# in system mode, but we can only return in clean way from
	# the interrupt mode, as we are not able to restore the cpsr
	# and the link register of the interrupted program while
	# returning to the interrupts link register (the place where
	# the interrupt occured).
	# So we first switch to the interrupt stack and preserve some regs
	# we then get everything from the system stack we need to return
	# for some things we use the registers we saved to the interrupt
	# stack (spsr -> r4, lr (for the interrupt) -> r5, we use r6 so we
	# can easily switch to the interrupt stack again
	
	# switch back to the interrupt stack
	# in this case it is not necessary to disable the interrupts here
	# we do not call a subroutine here, so there is no danger to
	# destroy the link register of the subroutine we called when we get
	# interrupted
	
	mrs	r0,cpsr
	mov	r2,r0
	mov	r1,#0x1f
	mvn	r1,r1
	and	r0,r0,r1
	mov	r1,#0x12
	orr	r0,r0,r1
	msr	cpsr,r0

	# save some regs to the interrupt stack we need now

	stmfd	sp!,{r4-r6}

	# switch back to the system stack and get some stuff
	# back from the stack

	msr	cpsr,r2

	# we get from the stack
	# spsr -> r4
	# lr   -> r5 (for the interrupt)
	# lr   -> lr (for the interrupt procedure)
	
	ldmfd	sp!,{r4}
	ldmfd	sp!,{r5}
	ldmfd	sp!,{lr}

	# keep the cpsr so we can easily return to the 
	# system stack
	
	mov	r6,r0

	# pop volatile registers for the interrupted task

	ldmfd	sp!,{r0-r3,r12}

	# switch back to interrupt mode

	msr	cpsr,r6

	# put the spsr and the lr back in place

	msr	spsr,r4
	mov	lr,r5

	# pop the registers saved above

	ldmfd	sp!,{r4-r6}
	
        # finally return to the interrupted task and restore the original psr

	subs    pc,lr,#0x4

	.endm

