/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               L I S T                                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung einer einfach verketteten Liste.                          */
/*****************************************************************************/

#ifndef __List_include__
#define __List_include__

#include "object/queue.h"

/**
 * \class List
 * \brief A list implementation based on a single linked list
 **/
class List : public Queue {
 public:

  /**
   * \brief Get the first element of the list
   * \return The first element of the list
   **/
  Chain* first () { return head; }

  /**
   * \brief Add a new element at the beginning of the list
   * \param new_item The item to be added to the list
   **/
  void insert_first (Chain* new_item);

  /**
   * \brief Add a new element after another element.
   * \param old_item The element the new element should be added after
   * \param new_item The new element to be added to the list
   **/
  void insert_after (Chain* old_item, Chain* new_item);
};

#endif

