/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                         O R D E R E R D _ Q U E U E                       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung einer Liste, die hinsichtlich eines Komparators sortiert  */
/* ist.                                                                      */
/*****************************************************************************/

#ifndef __object_ordered_queue_h__
#define __object_ordered_queue_h__

#include "object/chain.h"
#include "object/queue.h"

/**
 * \brief An ordered queue
 *
 * The elements in the queue are ordered due to a comparator
 * specified by a template parameter
 **/
template < class COMPARATOR > class Ordered_Queue : protected Queue {
public:
  /**
   * \brief Inserts an item into the queue preserving the order
   *        with respect to the comparator
   * \param item The element to be added.
   **/
  void enqueue(Chain* item);

  /**
   * \brief Return the first element within the queue and remove it.
   * \return The first element within the queue
   **/
  Chain* dequeue() {
    return Queue::dequeue();
  }

  /**
   * \brief Remove an element of the queue.
   * \param item The element that should be removed.
   **/
  void remove(Chain* item) {
    Queue::remove(item);
  }
};

template < class COMPARATOR > 
void Ordered_Queue< COMPARATOR >::enqueue(Chain* item) {
  if(head) {
    Chain* preceeding_item = 0;
    Chain* current_item = head;
    
    while((current_item != 0) && 
	  COMPARATOR::compare(item,current_item) >= 0) {
      preceeding_item = current_item;
      current_item = current_item->next;
    }

    if(preceeding_item) {
      if(preceeding_item->next) {
	item->next = preceeding_item->next;
	preceeding_item->next = item;
      }
      else {
	Queue::enqueue(item);
      }
    }
    else {
      push_back(item);
    }
  }
  else {
    Queue::enqueue(item);
  }
}

#endif /* __object_ordered_list_h__ */
