/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                T _ L I S T                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* A templatized list                                                        */
/*****************************************************************************/

#ifndef __t_list_h__
#define __t_list_h__

#include "object/list.h"

/**
 * \class T_List
 * \brief The templatized variant of class List
 * \see List
 **/
template< class T > class T_List : protected List {
public:
  /**
   * \brief Append an element at the end of the queue
   * \param item The element to be added.
   **/
  void enqueue(T* item) {
    Queue::enqueue(item);
  }

  /**
   * \brief Add an element at the beginning of a queue.
   * \param item The element to be added.
   **/
  void push_back(T* item) {
    Queue::push_back(item);
  }

  /**
   * \brief Get the first element of the list
   * \return The first element of the list
   **/
  T* first() { 
    return static_cast< T* >(List::first());
  }

  /**
   * \brief Return the first element within the queue and remove it.
   * \return The first element within the queue
   **/
  T* dequeue() { 
    return static_cast< T* >(Queue::dequeue());
  }

  /**
   * \brief Remove an element of the queue.
   * \param item The element that should be removed.
   **/
  void remove(T* item) {
    Queue::remove(item);
  }

  /**
   * \brief Add a new element at the beginning of the list
   * \param new_item The item to be added to the list
   **/
  void insert_first (T* new_item) {
    List::inser_first(new_item);
  }

  /**
   * \brief Add a new element after another element.
   * \param old_item The element the new element should be added after
   * \param new_item The new element to be added to the list
   **/
  void insert_after (T* old_item, T* new_item) {
    List::insert_afer(old_item,new_item);
  }
};

#endif /* __t_list_h__ */
