/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                              T _ S T A C K                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Templatized version of class Stack                                        */
/*****************************************************************************/

#ifndef __t_stack_h__
#define __t_stack_h__

#include "object/stack.h"

/**
 * \class T_Stack
 * \brief The templatized variant of class Stack
 * \see Stack
 **/
template< class T > class T_Stack : protected Stack {
public:

  /**
   * \brief Get the topmost element of the stack but don't remove it
   * \return The topmost element of the stack
   **/
  T* peek() { 
    return static_cast< T* >(Stack::peek());
  }

  /**
   * \brief Get the topmost element of the stack and remove it
   * \return the topmost element of the stack
   **/
  T* pop() { 
    return static_cast< T* >(Stack::pop());
  }

  /**
   * \brief Add an element to the stack
   * \param item The element to be added to the stack
   * \attention Each element may only be added once, otherwise the internal
   *            structure of the stack will be destroyed.
   **/
  void push(T* item) {
    Stack::push(item);
  }

  /**
   * \brief Remove an element of the stack
   * \param item The element to be removed from the stack
   **/
  void remove(T* item) {
    Stack::remove(item);
  }
};

#endif /* __t_stack_h__ */
