/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                             S C H E D U L E R                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Schnittstelle des Schedulers.                                             */
/*****************************************************************************/

#ifndef __scheduler_base_h__
#define __scheduler_base_h__

#include "thread/thread.h"

/**
 * \class Scheduler_Base
 * \brief The scheduler
 */
class Scheduler_Base {

  static volatile bool need_reschedule;

protected:

  /**
   * \brief Scheduling is necessary.
   */
  void set_need_reschedule() { need_reschedule = true; }
  /**
   * \brief Clear the need_reschedule flag.
   */
  void clear_need_reschedule() { need_reschedule = false; }

public:

  /**
   * \brief Check whether we have to schedule.
   */
  bool get_need_reschedule() { return need_reschedule; }
};

#endif /* __scheduler_base_h__ */
