#include "debug/random.h"
#include "infra/types.h"

/**
 * taken as is from 
 * http://de.wikipedia.org/wiki/Mersenne-Twister
 **/

ezstubs_uint32 mersenne_twister(void) {
  const ezstubs_uint32 N = 624;
  const ezstubs_uint32 M = 397;
  const ezstubs_uint32 A[2] = { 0, 0x9908b0df };
  const ezstubs_uint32 HI = 0x80000000;
  const ezstubs_uint32 LO = 0x7fffffff;

  static ezstubs_uint32 y[N];
  static ezstubs_uint32 index = N+1;

  if(index >= N) {
    if(index > N) {
      // initialisiere y mit Pseudozufallszahlen:
      ezstubs_uint32 r = 9, s = 3402;

      for(ezstubs_uint32 i = 0;i < N;++i) {
	r = 509845221 * r + 3;
	s *= s + 1;
	y[i] = s + (r >> 10);
      }
    }

    ezstubs_uint32 h;
    for(ezstubs_uint32 k = 0;k < N - M;++k) {
      h = (y[k] & HI) | (y[k+1] & LO);
      y[k] = y[k+M] ^ (h >> 1) ^ A[h & 1];
    }

    for(ezstubs_uint32 k = N - M;k < N-1;++k) {
      h = (y[k] & HI) | (y[k+1] & LO);
      y[k] = y[k+(M-N)] ^ (h >> 1) ^ A[h & 1];
    }

    h = (y[N-1] & HI) | (y[0] & LO);
    y[N-1] = y[M-1] ^ (h >> 1) ^ A[h & 1];
    index = 0;
  }

  ezstubs_uint32 e = y[index++];
  // tempering:
  e ^= (e >> 11);
  e ^= (e << 7) & 0x9d2c5680;
  e ^= (e << 15) & 0xefc60000;
  e ^= (e >> 18);
  return e;
}

void random_init() {
  for(ezstubs_uint16 i = 0;i < 20000;++i) {
    mersenne_twister();
  }
}

ezstubs_uint32 random() {
  return mersenne_twister();
}
