/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                    D S R _ E x e c u t o r _ B a s e                      */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Diese Klasse fuehrt die DSRs die vom DSR_Store aufbewahrt werden, je nach */
/* Implementierung werden diese Epiloge auf dem Interrupt-Stack oder auf dem */
/* Stack des gegewärtigen Fadens ausgeführt.                                 */
/*****************************************************************************/

#ifndef __interrupt_dsr_executor_base_h__
#define __interrupt_dsr_executor_base_h__

#include "interrupt/dsr_store.h"
#include "interrupt/gate.h"

/**
 * \brief Executes pending dsrs
 *
 * Used by the complete implementation to invoke pending dsrs, dependent on
 * the implementation the dsrs are either executed on interrupt or thread
 * stack
 **/
class DSR_Executor_Base : public DSR_Store {
public:

  /**
   * \brief Execute the pending dsrs
   **/
  void execute_pending_dsrs_inner() {
    Gate* item = 0;

    while((item = remove_dsr()) != (Gate*)0) {
      item->queued(false);
      item->dsr();
    }
  }
};

#endif /* __interrupt_dsr_executor_base_h__ */
