/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               S E C U R E                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die Klasse Secure dient dem Setzen und Freigeben der Sperrvariablen, mit  */
/* der die kritischen Abschnitte des Betriebssystemkerns geschuetzt werden.  */
/* Im Konstruktor der Klasse wird die Sperre gesetzt, im Destruktor wieder   */
/* freigegeben. Dadurch genuegt schon die Deklaration eines Secure Objekts,  */
/* um den gesamten Geltungsbereich als kritischen Abschnitt zu schuetzen.    */
/*****************************************************************************/

#ifndef __Secure_include__
#define __Secure_include__

/* INCLUDES */

#include "interrupt/guard.h"

/**
 * \class Secure
 * \brief Enter and leave the critical sections of the operating system kernel
 *
 * The class Secure enters and leaves the critical sections of the operating 
 * system kernel by a mechanism called scoped locking. An object of type Secure
 * is put onto the stack. When the surrounding scope is entered, the constructor
 * of Secure entering the critical section will be called. When the surrounding
 * scope is left again, the destructor of Secure is called, hence the critical
 * section is left.
 */
class Secure {

public:

  /**
   * \brief Constructor. Enters the crititcal section.
   */
  Secure ()  { guard.enter (); }
  
  /**
   * \brief Destructor. Leaves the crititcal section.
   */
  ~Secure () { guard.leave (); }
};

#endif
