// evtl. benoetigte Header werden eingebunden
#include "thread/guarded_scheduler.h"
#include "thread/thread.h"
#include "debug/testing.h"
#include "thread/schedule_table.h"

// Aufzeichnung des Verlaufs wird initialisiert
char test_sequence[4];
const char* right_sequence = "aba";
volatile int counter = 0;

// Fadenimplementierung fuer den Testfall, enthaelt 
// die Anwendungslogik des Testfalls
class MyThread : public Thread
{
private:
    char thread_char;
public:
    MyThread(char c) : thread_char(c) {};
    void action()
    {
        test_sequence[counter++] = thread_char;
        scheduler.exit();
    };
};

// der Checker_Thread ueberprueft abschliessend die Sequenz
class CheckerThread : public Thread
{
public:
    CheckerThread()  {};
    void action()
    {
        if(!check_sequence(right_sequence, test_sequence))
        {
            Panic("Test failed!");
        }
        else
        {
            TestOK("Test successful!");
        }
        scheduler.exit();
    };
};

// Stack allokieren, Ablauftabelle und Faeden anlegen
static unsigned int stack[256];
Schedule_Table<4> table(&stack[256], 100000);
MyThread T1('a');
MyThread T2('b');
CheckerThread Tchecker;

// Faeden hinzufuegen, Tabelle uebergeben und Scheduler starten
void user_main()
{
    init_sequence(right_sequence, test_sequence);

    table.add(0,    &T1);
    table.add(1000, &T2);
    table.add(2000, &T1);
    table.add(3000, &Tchecker);

    scheduler.set_schedule_table(&table);
}
