/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*     G U A R D E D _ S C H E D U L E _ T A B L E _ S C H E D U L E R       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Schnittstelle der eigentlichen Schedulerimplementierung, die gegen        */
/* Unterbrechungen geschützt ist.                                            */
/*****************************************************************************/

#ifndef __guarded_schedule_table_scheduler_h__
#define __guarded_schedule_table_scheduler_h__

#include "interrupt/secure.h"
#include "thread/abstract_schedule_table.h"
#include "thread/schedule_table_scheduler.h"

/**
 * \class Guarded_Schedule_Table_Scheduler
 * \brief  A thread safe interface for the Scheduler_Implementation
 */
class Guarded_Schedule_Table_Scheduler : protected Schedule_Table_Scheduler {
public:

  void set_schedule_table(Abstract_Schedule_Table* schedule_table);

  Abstract_Schedule_Table* switch_schedule_table(Abstract_Schedule_Table* schedule_table);

  void start();

  void exit();
};

#endif /* __guarded_schedule_table_scheduler_h__ */
