/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                   G U A R D E D _ S C H E D U L E R                       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Schnittstelle des Schedulers, der gegen unterbrechungen geschuetzt ist.   */
/*****************************************************************************/

#ifndef __guarded_scheduler_h__
#define __guarded_scheduler_h__

#include "interrupt/secure.h"
#include "thread/guarded_schedule_table_scheduler.h"

/**
 * \class Guarded_Scheduler
 * \brief A thread safe interface for the Scheduler
 *
 * This class provides the interface to the scheduler that should be used by
 * the application, as this interface is secured against interrupts and
 * therefore ensures consistency of kernel data structures.
 */
class Guarded_Scheduler : public Guarded_Schedule_Table_Scheduler {

public:

  /**
   * \brief Start the scheduler.
   * \attention May only be called once!
   * \attention This method does not return!
   */
  void start() {
    Guarded_Schedule_Table_Scheduler::start();
  }

  void reschedule() {
    Guarded_Schedule_Table_Scheduler::reschedule();
  }

  bool get_need_reschedule() {
    return Guarded_Schedule_Table_Scheduler::get_need_reschedule();
  }
};

extern Guarded_Scheduler scheduler;

#endif /* __guarded_scheduler_h__ */
