/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                     S C H E D U L E _ T A B L E                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* This class represents the schedule that is executed by the Schedule-Table-*/
/* Scheduler.                                                                */
/*---------------------------------------------------------------------------*/

#ifndef __schedule_table_h__
#define __schedule_table_h__

#include "infra/types.h"
#include "infra/utils.h"
#include "thread/abstract_schedule_table.h"
#include "thread/thread.h"

/**
 * \class Schedule_Table
 * \brief A schedule table of a certain size.
 *
 * The reason why the Schedule_Table-class is implemented as a template is, that
 * in EZStubs there is no dynamic memory management available. So we have to 
 * allocate the storage for our schedule table statically. But how can we do this
 * without using templates?
 */
template< ezstubs_uint8 SIZE > class Schedule_Table : public Abstract_Schedule_Table {

public:
  Schedule_Table_Entry schedule_table[SIZE + 1];

public:

  
  /**
   * \brief Constructor
   * \param tos A pointer to the top of the stack the schedule table runs on.
   * \param round The duration of a scheduler round, ie. the schedule table
   *              will be executed periodically every round microseconds
   **/
  Schedule_Table(void* tos,us_type round) : Abstract_Schedule_Table(tos,round,schedule_table) {
    schedule_table[SIZE].offset = round;
  }

  /**
   * \brief Returns to size of the schedule table
   * \return The size of the schedule table
   **/
  ezstubs_uint8 size(){
	return SIZE;
  }
};

#endif /* __schedule_table_h__ */
