/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                       G U A R D E D _ M U T E X                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* The user interface for a  typical mutex used to ensure mutual exclusion   */
/* among concurrend threads within critical sections.                        */
/*****************************************************************************/

#ifndef __guarded_mutex_h__
#define __guarded_mutex_h__

#include "interrupt/secure.h"
#include "thread/mutex.h"

/**
 * \class Guarded_Mutex
 * \brief The user interface of a mutex used to ensure mutual exclusion in
 *        critical sections.
 **/
class Guarded_Mutex : protected Mutex {
public:

  /**
   * \brief enter a critical section
   * \retval true The mutex has successfully been locked
   * \retval false The mutex has not been locked successfully.
   * \see Guarded_Mutex::unlock
   * \see Mutex::lock
   *
   * By calling this method a critical section is entered. It is ensured that
   * other flow of control can succesfully call this method as long as the
   * mutex has not been unlocked by calling the unlock()-method. The precise
   * semantics of this method however depend on the particular synchronization
   * protocol implemented by the mutex.
   **/
  bool lock() {
    return false;
  }

  /**
   * \brief leave a critical section.
   * \retval true The mutex has successfully been unlocked
   * \retval false The mutex has not been unlocked successfully.
   * \see Guarded_Mutex::Mutex::lock
   * \see Mutex::unlock
   *
   * By calling this method a critical section is locked other flows of control
   * are now able to successfully call the method lock() and enter this critical
   * section on their own. As for the method() lock() the precise semantics of
   * this method are defined by the implemented synchronization protocol.
   **/
  bool unlock() {
    return false;
  }

  /**
   * \brief Register with the mutex
   * \param thread A thread that wants to use the mutex.
   *
   * In order to compute the proper ceiling priority it has be known in
   * advance which thread will try to lock a specific mutex. Therefore
   * all threads that want to use a particular mutex first have to be
   * registered with the mutex.
   **/
  void enlist(Mutex_Thread* thread) {
  }
};

#endif /* __guarded_mutex_h__ */
