/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          M U T E X _ T H R E A D                          */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* A Thread that is allowed to lock and unlock a mutex.                      */
/*****************************************************************************/

#ifndef __mutex_thread_h__
#define __mutex_thread_h__

#include "infra/types.h"
#include "object/t_stack.h"
#include "thread/mutex.h"
#include "thread/thread.h"

/**
 * \class Mutex_Thread
 * \brief A thread that is capable of locking a mutex.
 *
 * For the implementation of the stack based priority ceiling protocol it is
 * necessary to manage all the mutexes held by a thread in a stack. In order
 * not to impose this overhead on all threads, only special threads are allowed
 * to lock mutexes, namely threads derived from the class Mutex_Thread.
 **/
class Mutex_Thread : public Thread, public T_Stack< Mutex > {
public:

  /**
   * \brief Constructor
   * \param prio The threads' priority
   * \param tos A pointer to the threads' stack
   **/
  Mutex_Thread(ezstubs_uint8 prio,void* tos) : Thread(prio,tos) {}


  /**
   * \brief Get the threads' current priority
   * \return The threads' current priority
   *
   * When a thread locked a mutex, its current priority is not its static
   * assigned priority but the ceiling priority of the mutex locked at last. 
   * This mutex can be looked up in the stack of locked mutexes.
   **/
  virtual ezstubs_uint8 get_priority() {
    return 0;
  }
};

#endif /* __mutex_thread_h__ */
