#include "ezs_equalizer.h"
#include <assert.h>

void ezs_equalizer_set_band(EZS_Equalizer *eq, size_t band, uint8_t value)
{
  assert(band < EZS_EQUALIZER_BANDS);
  assert(value <= 100);

  eq->band[band] = value;
}

void ezs_equalizer_init(EZS_Equalizer *eq)
{
  {
    int band = 0;
    for (band = 0; band < EZS_EQUALIZER_BANDS; ++band) {
      ezs_equalizer_set_band(eq, band, 100);
    }
  }
}

int16_t ezs_equalizer_filter(EZS_Equalizer *eq, int16_t value)
{
  return value;
}

void ezs_equalizer_destroy(EZS_Equalizer *eq)
{
}
