#include "ezs_wave.h"

#include <stdio.h>
#include <string.h>

EZS_Wave_Error_t ezs_wopen(EZS_Wave *wave, char filename[12]) {

  wave->file            = NULL;
  wave->format_tag      = 0xde;
  wave->channels        = 0xad;
  wave->sample_rate     = 0xdead;
  wave->avg_bytes_sec   = 0xdead;
  wave->block_align     = 0xde;
  wave->bits_per_sample = 0xad;
  wave->data_size       = 0xdead;

  wave->file = fopen(filename, "r");
  if (wave->file == NULL) return WAVE_FILE_NOT_FOUND;


  char id[4];
  fread(id, sizeof(char), 4, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }
  if (memcmp(id, "RIFF", 3) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  uint32_t size;
  fread(&size, sizeof(uint32_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  fread(id, sizeof(char), 4, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }
  if (memcmp(id, "WAVE", 4) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  fread(id, sizeof(char), 4, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }
  if (memcmp(id, "fmt ", 4) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  uint32_t format_length;
  fread(&format_length, sizeof(uint32_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  fread(&wave->format_tag, sizeof(int16_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }
  /*
     * we consider every other format than uncompressed PCM an error
   */
  if (wave->format_tag != 1) {
    fclose(wave->file);
    return 0;
  }

  fread(&wave->channels, sizeof(int16_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return 0;
  }

  fread(&wave->sample_rate, sizeof(uint32_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  fread(&wave->avg_bytes_sec, sizeof(uint32_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  fread(&wave->block_align, sizeof(int16_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  fread(&wave->bits_per_sample, sizeof(int16_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }
  if (wave->bits_per_sample != 16) {
    fclose(wave->file);
    return WAVE_ERROR;
  }
  wave->bytes_per_sample = wave->bits_per_sample / 8;

  fread(id, sizeof(char), 4, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }
  if (memcmp(id, "data", 4) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  fread(&wave->data_size, sizeof(uint32_t), 1, wave->file);
  if (ferror(wave->file) != 0) {
    fclose(wave->file);
    return WAVE_ERROR;
  }

  return WAVE_OK;
}

int ezs_wread(EZS_Wave *wave, void *buffer) {
  if (wave == NULL) return WAVE_ERROR;
  if (buffer == NULL) return WAVE_ERROR;

  fread(buffer, sizeof(char), (size_t) (wave->bytes_per_sample * wave->channels), wave->file);
  if (feof(wave->file) != 0) {
    fprintf(stderr, "ezs_wread(): EOF\n");
    return WAVE_EOF;
  }

  if (ferror(wave->file) != 0) {
    fprintf(stderr, "ezs_wread(): stream error\n");
    return WAVE_ERROR;
  }

  return WAVE_OK;
}

int ezs_wclose(EZS_Wave *wave) {
  if (fclose(wave->file) == 0) return WAVE_OK;

  return WAVE_ERROR;
}

void ezs_wprint_header(EZS_Wave *wave)
{
  printf("TEST.WAV:\n"
      "\tFormat: %d\n"
      "\tchannels: %d\n"
      "\tsample rate: %d\n"
      "\taverage bytes: %d\n"
      "\tblock align: %d\n"
      "\tbits per sample: %d\n"
      "\tbytes per sample: %d\n"
      "\tdata size: %d\n",
      wave->format_tag,
      wave->channels,
      wave->sample_rate,
      wave->avg_bytes_sec,
      wave->block_align,
      wave->bits_per_sample,
      wave->bytes_per_sample,
      wave->data_size);
}
