#include <sml/ttkernel/c_api.h>
#include <pkgconf/ttkernel.h>
#include <stdio.h>

#include "ezs_fb.h"
#include "ezs_sb16.h"
#include "ezs_counter.h"
#include "ezs_trace.h"
#include <cyg/io/framebuf.h>
#include <cyg/io/framebufs/i386_fb.h>

SB16 sb16;

tt_DispatcherTable(table1, 10);

tt_Task(t1){
    printf("Task1\n");
}

tt_Task(t2){
    printf("Task2\n");
}

ttIdleTask {
    while(1);
}


externC void cyg_user_start(){
	// Initialize framebuffer in graphic mode
	ezs_fb_init();
	// Initialize HPET counter
	ezs_counter_init();
	// Initialize soundblaster
	ezs_sb16_init(&sb16,
			0x220 /* io address */,
			5 /* interrupt */,
			1 /* 8 bit DMA */,
			5 /* 16 bit DMA */);
	// Initialize Tracer
	int res = ezs_trace_init();
	printf("init res: %d\r\n" , res);

	printf("Time triggered!\r\n");
	tt_InitTask(t1, TT_STRINGENT);
	tt_InitTask(t2, TT_STRINGENT);
	
	tt_InitDispatcherTable(table1);
	bool valid = 1;
	valid &= tt_DispatcherTableEntry( table1,   100,  TT_START_TASK, t2);
	valid &= tt_DispatcherTableEntry( table1,   190,  TT_DEADLINE, t2);
	valid &= tt_DispatcherTableEntry( table1,   200,  TT_START_TASK, t2);
	valid &= tt_DispatcherTableEntry( table1,   290,  TT_DEADLINE, t2);
	valid &= tt_DispatcherTableEntry( table1,   500,  TT_START_TASK, t1);
	valid &= tt_DispatcherTableEntry( table1,   490,  TT_DEADLINE, t1);
	valid &= tt_DispatcherTableEntry( table1,   300,  TT_START_TASK, t2);
	valid &= tt_DispatcherTableEntry( table1,   310,  TT_DEADLINE, t2);

	if(!valid) printf("WARNING: Table not valid!\n");

	 ttStartOS(table1);

}
