#include <cyg/hal/hal_arch.h>
#include <cyg/kernel/kapi.h>
#include <stdio.h>
#include <stdint.h>

#include "ezs_fb.h"
#include "ezs_dac.h"
#include <math.h>

/**
 * @file
 * @brief User-defined function, implementing thread startup and execution
 */

/**
 * @brief Test function showing some capabilities of the Framebuffer device
 * @note Don't forget to initialize the FB via @see ezs_fb_init()
 *       Best practice is to call the initializer in cyg_user_start()
 *
 * @note The Framebuffer is actually not needed in this exercise.
 *       This test function is only for presentation issues.
 */
void framebuffer_test(){
	int i;
	int size = 10;
	for( i = 0; i < 256; i++){
		int col = size * (i % 16);
		int row = size * (i / 16);

		ezs_fb_fill_block(col+16*8+10, row, size, size, i);

	}
	size = 8;
	for(i=0; i < 2048 / 8; i++) {
		int row = size * (i % 16);
		int col = size * (i / 16);

		ezs_fb_print_char(i, row, col, FB_WHITE);
	}
}


// We already defined the necessary thread handle
// and stack for your convenience.
// QUESTION: Why are these variables (objects) residing exactly here?!
#define STACKSIZE CYGNUM_HAL_STACK_SIZE_MINIMUM+1024 //!< Should be more than enough Stack for our purposes
static cyg_uint8 my_stack[STACKSIZE]; //!< The thread's stack
static cyg_handle_t handle;           //!< The handle for thread control
static cyg_thread   threaddata;       //!< Some thread internal data


// Implement your  *THREAD* function here:
// void ...


/**
 * @brief User-defined startup function
 *
 * Don't forget to resume your thread at the end!
 */
void cyg_user_start() {
    /* Initialize framebuffer device */
    ezs_fb_init();

    /* Some test function presenting the FB capabilities. */
    framebuffer_test();

    /* *CREATE* your thread */

    /* *RESUME* the thread*/

    /* Finally, *RETURN*, to allow eCos start scheduling. */

}



