#include <stdint.h>

uint64_t rdtsc_start()
{
    uint32_t cycles_high;
    uint32_t cycles_low;

    __asm__ volatile (
        "cpuid\n\t"
        "rdtsc\n\t"
        : "=d"(cycles_high), "=a"(cycles_low)
        :
        : "rbx", "rcx", "memory"
    );

    uint64_t out = (((uint64_t)cycles_high) << 32) | ((uint64_t)cycles_low);
    return out;
}

uint64_t rdtsc_stop()
{
    uint32_t cycles_high;
    uint32_t cycles_low;

    __asm__ volatile (
        "rdtscp\n\t"
        "mov %%edx, %0\n\t"
        "mov %%eax, %1\n\t"
        "cpuid\n\t"
        : "=m"(cycles_high), "=m"(cycles_low)
        :
        : "rax", "rbx", "rcx", "rdx", "memory"
    );

    uint64_t out = (((uint64_t)cycles_high) << 32) | ((uint64_t)cycles_low);
    return out;
}
