#include <cyg/hal/hal_arch.h>
#include <cyg/kernel/kapi.h>

#include <stdio.h>
#include <math.h>
#include <assert.h>

#include "ezs_counter.h"
#include "ezs_stopwatch.h"
#include "ezs_adc.h"
#include "ezs_dac.h"
#include "ezs_fb.h"
#include "ezs_fft.h"
#include "ezs_interpolation.h"
#include "ezs_plot.h"
#include "ezs_plot_pds.h"

/*
 * TODO: Code anpassen
 */
#define SAMPLING_TASK_PRIORITY 0
#define PROCRASTINATION_TASK_PRIORITY 0
#define DISPLAY_SIGNAL_TASK_PRIORITY 0
#define DISPLAY_LDS_TASK_PRIORITY 0
#define ANALYSIS_TASK_PRIORITY 0
#define DECODING_TASK_PRIORITY 0
#define POLLING_TASK_PRIORITY 0
#define STATEMACHINE_TASK_PRIORITY 0

#define SAMPLING_TASK_PERIOD 0
#define PROCRASTINATION_TASK_PERIOD 0
#define DISPLAY_SIGNAL_TASK_PERIOD 0
#define DISPLAY_LDS_TASK_PERIOD 0
#define ANALYSIS_TASK_PERIOD 0
#define POLLING_TASK_PERIOD 0

#define SAMPLING_WCET 0
#define PROCRASTINATION_WCET 0
#define DECODING_WCET 0

#define SAMPLING_TASK_PHASE 0
#define PROCRASTINATION_TASK_PHASE 0
#define ANALYSIS_TASK_PHASE 0
#define DISPLAY_SIGNAL_TASK_PHASE 0
#define DISPLAY_LDS_TASK_PHASE 0
#define POLLING_TASK_PHASE 0

#define STACKSIZE    (CYGNUM_HAL_STACK_SIZE_MINIMUM+4096)

#define FFT_LENGTH 128
#define TIME_DOMAIN_LENGTH 2 * FFT_LENGTH
static cyg_uint32 s_time_domain[TIME_DOMAIN_LENGTH];
static float s_frequency_domain[FFT_LENGTH];
static unsigned int s_position = 0;

#define KEYBOARD_BUFFER_LENGTH 15
static char s_keyboard_buffer[KEYBOARD_BUFFER_LENGTH];
static unsigned int s_keyboard_position;
static bool s_command_decodable = false;

#define KBDATAPORT 0x0060   // data I/O port
#define KBSTATPORT 0x0064   // status port (read)

static int packet_receive(char c)
{
  assert(s_keyboard_position < KEYBOARD_BUFFER_LENGTH);
  /*
   * TODO: Code ergaenzen
   */

}

enum Command
{
  DisplayTime = (1 << 1),
  DisplayPDS  = (1 << 2),
  TriggerOn   = (1 << 3),
  TriggerOff  = (1 << 4),
  TLevelRise  = (1 << 5),
  TLevelFall  = (1 << 6),
  Invalid     = 0x00,
};

enum State
{
  ChangeMe =(1 << 1),
  /*
   * TODO: Zustände ergaenzen
   */
};

enum Command decode_command(void)
{

  enum Command ret = Invalid;

  /*
   * TODO: Code ergaenzen
   */

  return ret;
}

static cyg_uint8 s_scancode;
cyg_uint32 keyboard_isr_handler(cyg_vector_t vector, cyg_addrword_t data)
{
  /*
   * TODO: Code ergaenzen
   */
  cyg_uint8 kbstat;
  HAL_READ_UINT8( KBSTATPORT, kbstat ); 
  // If Data available, read them -> implicitly acknowledges interrupt!
  if( (kbstat & 0x01) != 0 ){
    HAL_READ_UINT8( KBDATAPORT, s_scancode );
  }

  cyg_interrupt_acknowledge(vector);

  return (CYG_ISR_HANDLED | CYG_ISR_CALL_DSR);
}


void keyboard_dsr_handler(cyg_vector_t vec, cyg_ucount32 count, cyg_addrword_t data)
{

  /*
   * TODO: Code ergaenzen
   */
  if (!(s_scancode & 0x80)) {
    //Nur TastenDRUECKE behandeln.
    //ACHTUNG: Die Tastatur ist ENGLISCH
  }
}


// periodischer Zusteller
// T7
static cyg_uint8     polling_task_stack[STACKSIZE];
static cyg_handle_t  polling_task_handle;
static cyg_thread    polling_task_thread;
static void polling_task_entry(cyg_addrword_t data)
{
  while (1) {
    /*
     * TODO: Code ergaenzen
     */
    cyg_thread_suspend(cyg_thread_self());
  }
}

// Zustandsmaschine
// T8
static cyg_uint8     statemachine_task_stack[STACKSIZE];
static cyg_handle_t  statemachine_task_handle;
static cyg_thread    statemachine_task_thread;
static void statemachine_task_entry(cyg_addrword_t data)
{
  while (1) {
    /*
     * TODO: Code ergaenzen
     */
  }
}

// T1
static cyg_uint8     sampling_task_stack[STACKSIZE];
static cyg_handle_t  sampling_task_handle;
static cyg_thread    sampling_task_thread;
static void sampling_task_entry(cyg_addrword_t data)
{
  while (1) {
    /*
     * TODO: Code ergaenzen
     */

    cyg_thread_suspend(cyg_thread_self());
  }
}

// T2
static cyg_uint8     procrastination_task_stack[STACKSIZE];
static cyg_handle_t  procrastination_task_handle;
static cyg_thread    procrastination_task_thread;
static void procrastination_task_entry(cyg_addrword_t data)
{
  while (1) {
    /*
     * TODO: Code ergaenzen
     */

    cyg_thread_suspend(cyg_thread_self());
  }
}

// T3
static cyg_uint8     analysis_task_stack[STACKSIZE];
static cyg_handle_t  analysis_task_handle;
static cyg_thread    analysis_task_thread;
static void analysis_task_entry(cyg_addrword_t data)
{
  while (1) {
    /*
     * TODO: Code ergaenzen
     */

    cyg_thread_suspend(cyg_thread_self());
  }
}


// T4
static cyg_uint8     display_signal_task_stack[STACKSIZE];
static cyg_handle_t  display_signal_task_handle;
static cyg_thread    display_signal_task_thread;
static void display_signal_task_entry(cyg_addrword_t data)
{
  while (1) {
    /*
     * TODO: Code ergaenzen
     */

    cyg_thread_suspend(cyg_thread_self());
  }
}

// T5
static cyg_uint8     display_lds_task_stack[STACKSIZE];
static cyg_handle_t  display_lds_task_handle;
static cyg_thread    display_lds_task_thread;
static void display_lds_task_entry(cyg_addrword_t data)
{
  while (1) {
    /*
     * TODO: Code ergaenzen
     */

    cyg_thread_suspend(cyg_thread_self());
  }
}

static void sampling_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
  cyg_thread_resume(sampling_task_handle);
}

static void procrastination_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
  cyg_thread_resume(procrastination_task_handle);
}

static void analysis_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
  cyg_thread_resume(analysis_task_handle);
}

static void display_signal_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
  cyg_thread_resume(display_signal_task_handle);
}

static void display_lds_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
  cyg_thread_resume(display_lds_task_handle);
}


static cyg_handle_t sampling_task_alarm_handle;
static cyg_handle_t procrastination_task_alarm_handle;
static cyg_handle_t analysis_task_alarm_handle;
static cyg_handle_t display_signal_task_alarm_handle;
static cyg_handle_t display_lds_task_alarm_handle;

static cyg_alarm sampling_task_alarm;
static cyg_alarm procrastination_task_alarm;
static cyg_alarm analysis_task_alarm;
static cyg_alarm display_signal_task_alarm;
static cyg_alarm display_lds_task_alarm;


static cyg_handle_t real_time_counter;

static cyg_addrword_t data_dummy = 0;
static cyg_interrupt intr;
static cyg_handle_t  keyboard_isr_handle;

void cyg_user_start(void)
{
  diag_printf("Entering cyg_user_start() function\n");
  printf("Entering cyg_user_start() function\n");
  ezs_fb_init();
	ezs_counter_init();

  cyg_interrupt_create(CYGNUM_HAL_INTERRUPT_KEYBOARD, 1, 0, keyboard_isr_handler, keyboard_dsr_handler, &keyboard_isr_handle, &intr) ;
  cyg_interrupt_attach(keyboard_isr_handle);
  cyg_interrupt_unmask(CYGNUM_HAL_INTERRUPT_KEYBOARD);

  cyg_thread_create(SAMPLING_TASK_PRIORITY, &sampling_task_entry, 0, "sampling task",
      sampling_task_stack, STACKSIZE,
      &sampling_task_handle, &sampling_task_thread);
  cyg_thread_create(PROCRASTINATION_TASK_PRIORITY, &procrastination_task_entry, 0, "procrastination task",
      procrastination_task_stack, STACKSIZE,
      &procrastination_task_handle, &procrastination_task_thread);
  cyg_thread_create(ANALYSIS_TASK_PRIORITY, &analysis_task_entry, 0, "analysis task",
      analysis_task_stack, STACKSIZE,
      &analysis_task_handle, &analysis_task_thread);
  cyg_thread_create(DISPLAY_SIGNAL_TASK_PRIORITY, &display_signal_task_entry, 0, "display signal task",
      display_signal_task_stack, STACKSIZE,
      &display_signal_task_handle, &display_signal_task_thread);
  cyg_thread_create(DISPLAY_LDS_TASK_PRIORITY, &display_lds_task_entry, 0, "display lds task",
      display_lds_task_stack, STACKSIZE,
      &display_lds_task_handle, &display_lds_task_thread);

  cyg_clock_to_counter(cyg_real_time_clock(), &real_time_counter);

  cyg_alarm_create(real_time_counter, sampling_task_alarmfn, data_dummy, &sampling_task_alarm_handle, &sampling_task_alarm);
  cyg_alarm_initialize(sampling_task_alarm_handle, SAMPLING_TASK_PHASE, SAMPLING_TASK_PERIOD);
  cyg_alarm_create(real_time_counter, procrastination_task_alarmfn, data_dummy, &procrastination_task_alarm_handle, &procrastination_task_alarm);
  cyg_alarm_initialize(procrastination_task_alarm_handle, PROCRASTINATION_TASK_PHASE, PROCRASTINATION_TASK_PERIOD);

  cyg_alarm_create(real_time_counter, analysis_task_alarmfn, data_dummy, &analysis_task_alarm_handle, &analysis_task_alarm);
  cyg_alarm_initialize(analysis_task_alarm_handle, ANALYSIS_TASK_PHASE, ANALYSIS_TASK_PERIOD);

  cyg_alarm_create(real_time_counter, display_signal_task_alarmfn, data_dummy, &display_signal_task_alarm_handle, &display_signal_task_alarm);
  cyg_alarm_initialize(display_signal_task_alarm_handle, DISPLAY_SIGNAL_TASK_PHASE, DISPLAY_SIGNAL_TASK_PERIOD);
  cyg_alarm_create(real_time_counter, display_lds_task_alarmfn, data_dummy, &display_lds_task_alarm_handle, &display_lds_task_alarm);
  cyg_alarm_initialize(display_lds_task_alarm_handle, DISPLAY_LDS_TASK_PHASE, DISPLAY_LDS_TASK_PERIOD);
}
