#include "ezs_stopwatch.h"
#include "ezs_counter.h"
#include <stdlib.h>

void ezs_watch_start(cyg_uint32 * state){
	*state = ezs_counter_get();
}

cyg_uint32 ezs_watch_stop(cyg_uint32 * state){
	return  ezs_counter_get() - (*state);
}


void ezs_lose_time(cyg_uint32 wcet, cyg_uint8 percentage){
	cyg_uint32 previous_value = ezs_counter_get();
  cyg_uint8 percent = 100;
	const cyg_uint32 resolution = 50U;
	cyg_uint32 temp, diff;

  if (percentage > 0 && percentage <= 100 ) {
    percent = rand() % percentage;
  }

  cyg_int32 counter =( wcet - (wcet * percent)/100);

	//make sure we always return before the demanded wcet
	counter = counter - resolution;
	while(counter > 0){
		temp = ezs_counter_get();
		diff = temp - previous_value;
		// if we were not interrupted
		if (diff < resolution) {
			counter = counter - diff ;
		}
		previous_value = temp;
	}
}

