#include <cyg/hal/hal_arch.h>
#include <cyg/kernel/kapi.h>
#include <stdio.h>

#include "common.h"
/*
 * Die einzelnen Teilaufgaben sollen in den Dateien
 *
 * aufgabe_1.c
 * aufgabe_2.c
 * aufgabe_3.c
 *
 * geloest werden. Diese sind fuer die Bearbeitung der Teilaufgabe jeweils in
 * CMakeLists.txt _einzeln_ einzukommentieren.
 *
 * Datenstrukturen, die sowohl in app.c als auch in den Implementierungen der
 * Teilaufgaben verwendet werden, sollen in common.h deklariert werden.
 *
 * Programmcode, der allen Teilaufgaben gemeinsam ist, soll wie gewohnt in
 * app.c implementiert werden.
 *
 */

void cyg_user_start(void)
{
	printf("initializing HPET\n");
	ezs_counter_init();

	cyg_clock_to_counter(cyg_real_time_clock(), &s_real_time_counter);

	init_tasks();
}
